/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.content;

import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.ParticleEmitter;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.element.WorldSectionElement;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.scene.PonderStoryBoard;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class DebugScenes {
    private static int index;

    public static void registerAll(PonderSceneRegistrationHelper<class_2960> helper) {
        index = 1;
        DebugScenes.add(helper, DebugScenes::coordinateScene);
        DebugScenes.add(helper, DebugScenes::blocksScene);
        DebugScenes.add(helper, DebugScenes::fluidsScene);
        DebugScenes.add(helper, DebugScenes::offScreenScene);
        DebugScenes.add(helper, DebugScenes::particleScene);
        DebugScenes.add(helper, DebugScenes::controlsScene);
        DebugScenes.add(helper, DebugScenes::birbScene);
        DebugScenes.add(helper, DebugScenes::sectionsScene);
    }

    private static void add(PonderSceneRegistrationHelper<class_2960> helper, PonderStoryBoard sb) {
        String schematicPath = "debug/scene_" + index;
        helper.addStoryBoard(new class_2960("spyglass"), schematicPath, sb, new class_2960[0]).highlightAllTags();
        ++index;
    }

    public static void empty(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_empty", "Missing Content");
        scene.showBasePlate();
        scene.idle(5);
    }

    public static void coordinateScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_coords", "Coordinate Space");
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        Selection xAxis = util.select().fromTo(2, 1, 1, 4, 1, 1);
        Selection yAxis = util.select().fromTo(1, 2, 1, 1, 4, 1);
        Selection zAxis = util.select().fromTo(1, 1, 2, 1, 1, 4);
        scene.idle(10);
        scene.overlay().showOutlineWithText(xAxis, 20).colored(PonderPalette.RED).text("Das X axis");
        scene.idle(20);
        scene.overlay().showOutlineWithText(yAxis, 20).colored(PonderPalette.GREEN).text("Das Y axis");
        scene.idle(20);
        scene.overlay().showOutlineWithText(zAxis, 20).colored(PonderPalette.BLUE).text("Das Z axis");
    }

    public static void blocksScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_blocks", "Changing Blocks");
        scene.showBasePlate();
        scene.scaleSceneView(0.75f);
        scene.idle(10);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(1000).independent(10).text("Blocks can be modified");
        scene.idle(20);
        scene.world().replaceBlocks(util.select().fromTo(1, 1, 3, 2, 2, 4), class_2246.field_10107.method_9564(), true);
        scene.idle(10);
        scene.addKeyframe();
        scene.world().replaceBlocks(util.select().position(3, 1, 1), class_2246.field_10205.method_9564(), true);
        scene.rotateCameraY(180.0f);
        for (int i = 0; i < 20; ++i) {
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 1, 1));
            scene.idle(10);
        }
        scene.markAsFinished();
    }

    public static void fluidsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_fluids", "Showing Fluids");
        scene.showBasePlate();
        scene.idle(10);
        class_243 parrotPos = util.vector().topOf(1, 0, 1);
        scene.special().createBirb(parrotPos, ParrotPose.FacePointOfInterestPose::new);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        scene.overlay().showText(1000).text("Fluid rendering test.").pointAt(new class_243(1.0, 2.5, 4.5));
        scene.markAsFinished();
        Object outlineSlot = new Object();
        class_243 vec1 = util.vector().topOf(1, 0, 0);
        class_243 vec2 = util.vector().topOf(0, 0, 1);
        class_238 boundingBox1 = new class_238(vec1, vec1).method_1012(0.0, 2.5, 0.0).method_1009(0.15, 0.0, 0.15);
        class_238 boundingBox2 = new class_238(vec2, vec2).method_1012(0.0, 0.125, 0.0).method_1009(0.45, 0.0, 0.45);
        class_243 poi1 = boundingBox1.method_1005();
        class_243 poi2 = boundingBox2.method_1005();
        for (int i = 0; i < 10; ++i) {
            scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, outlineSlot, i % 2 == 0 ? boundingBox1 : boundingBox2, 15);
            scene.idle(3);
            scene.special().movePointOfInterest(i % 2 == 0 ? poi1 : poi2);
            scene.idle(12);
        }
        scene.idle(12);
        scene.special().movePointOfInterest(util.grid().at(-4, 5, 4));
        scene.overlay().showText(40).colored(PonderPalette.RED).text("wut?").pointAt(parrotPos.method_1031(-0.25, 0.25, 0.25));
    }

    public static void offScreenScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_baseplate", "Out of bounds / configureBasePlate");
        scene.configureBasePlate(1, 0, 6);
        scene.showBasePlate();
        Selection out1 = util.select().fromTo(7, 0, 0, 8, 0, 5);
        Selection out2 = util.select().fromTo(0, 0, 0, 0, 0, 5);
        Selection blocksExceptBasePlate = util.select().layersFrom(1).add(out1).add(out2);
        scene.addKeyframe();
        scene.idle(10);
        scene.world().showSection(blocksExceptBasePlate, class_2350.field_11033);
        scene.idle(10);
        scene.addKeyframe();
        scene.idle(20);
        scene.addKeyframe();
        scene.idle(20);
        scene.addKeyframe();
        scene.overlay().showOutlineWithText(out1, 100).colored(PonderPalette.BLACK).text("Blocks outside of the base plate do not affect scaling");
        scene.overlay().showOutlineWithText(out2, 100).colored(PonderPalette.BLACK).text("configureBasePlate() makes sure of that.");
        scene.markAsFinished();
    }

    public static void particleScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_particles", "Emitting particles");
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        scene.idle(10);
        class_243 emitterPos = util.vector().of(2.5, 2.25, 2.5);
        ParticleEmitter emitter = scene.effects().simpleParticleEmitter(class_2398.field_11239, util.vector().of(0.0, 0.1, 0.0));
        ParticleEmitter rotation = scene.effects().simpleParticleEmitter(class_2398.field_11238, util.vector().of(0.0, 0.1, 0.0));
        scene.overlay().showText(20).text("Incoming...").pointAt(emitterPos);
        scene.idle(30);
        scene.effects().emitParticles(emitterPos, emitter, 1.0f, 60);
        scene.effects().emitParticles(emitterPos, rotation, 20.0f, 1);
        scene.idle(30);
        scene.rotateCameraY(180.0f);
    }

    public static void controlsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_controls", "Basic player interaction");
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().layer(1), class_2350.field_11033);
        scene.idle(4);
        scene.world().showSection(util.select().layer(2), class_2350.field_11033);
        scene.idle(4);
        scene.world().showSection(util.select().layer(3), class_2350.field_11033);
        scene.idle(10);
        class_2338 shaftPos = util.grid().at(3, 1, 1);
        Selection shaftSelection = util.select().position(shaftPos);
        scene.overlay().showControls(util.vector().topOf(shaftPos), Pointing.DOWN, 40).rightClick().whileSneaking().withItem(class_1802.field_8209.method_7854());
        scene.idle(20);
        scene.world().replaceBlocks(shaftSelection, class_2246.field_10231.method_9564(), true);
        scene.idle(20);
        scene.world().hideSection(shaftSelection, class_2350.field_11036);
        scene.idle(20);
        scene.overlay().showControls(util.vector().of(1.0, 4.5, 3.5), Pointing.LEFT, 20).rightClick().withItem(new class_1799((class_1935)class_2246.field_10093));
        scene.world().showSection(util.select().layer(4), class_2350.field_11033);
        scene.idle(40);
        class_2338 chassis = util.grid().at(1, 1, 3);
        class_243 chassisSurface = util.vector().blockSurface(chassis, class_2350.field_11043);
        Object chassisValueBoxHighlight = new Object();
        Object chassisEffectHighlight = new Object();
        class_238 point = new class_238(chassisSurface, chassisSurface);
        class_238 expanded = point.method_1009(0.25, 0.25, 0.0625);
        Selection singleBlock = util.select().position(1, 2, 3);
        Selection twoBlocks = util.select().fromTo(1, 2, 3, 1, 3, 3);
        Selection threeBlocks = util.select().fromTo(1, 2, 3, 1, 4, 3);
        Selection singleRow = util.select().fromTo(1, 2, 3, 3, 2, 3);
        Selection twoRows = util.select().fromTo(1, 2, 3, 3, 3, 3);
        Selection threeRows = twoRows.copy().add(threeBlocks);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, chassisValueBoxHighlight, point, 1);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, chassisValueBoxHighlight, expanded, 120);
        scene.overlay().showControls(chassisSurface, Pointing.UP, 40).scroll().withItem(class_1802.field_8209.method_7854());
        PonderPalette white = PonderPalette.WHITE;
        scene.overlay().showOutline(white, chassisEffectHighlight, singleBlock, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, twoBlocks, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, threeBlocks, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, twoBlocks, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, singleBlock, 10);
        scene.idle(10);
        scene.idle(30);
        scene.overlay().showControls(chassisSurface, Pointing.UP, 40).whileCTRL().scroll().withItem(class_1802.field_8209.method_7854());
        scene.overlay().showOutline(white, chassisEffectHighlight, singleRow, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, twoRows, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, threeRows, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, twoRows, 10);
        scene.idle(10);
        scene.overlay().showOutline(white, chassisEffectHighlight, singleRow, 10);
        scene.idle(10);
        scene.markAsFinished();
    }

    public static void birbScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_birbs", "Birbs");
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        scene.idle(10);
        class_2338 pos = new class_2338(1, 2, 3);
        scene.special().createBirb(util.vector().blockSurface(pos, class_2350.field_11036), ParrotPose.FaceCursorPose::new);
        scene.overlay().showText(100).colored(PonderPalette.GREEN).text("More birbs = More interesting").pointAt(util.vector().topOf(pos));
        scene.idle(10);
        scene.special().createBirb(util.vector().topOf(0, 1, 2), ParrotPose.DancePose::new);
        scene.idle(10);
        scene.special().createBirb(util.vector().centerOf(3, 1, 3).method_1031(0.0, 0.25, 0.0), ParrotPose.FacePointOfInterestPose::new);
        scene.idle(20);
        class_2338 poi1 = util.grid().at(4, 1, 0);
        class_2338 poi2 = util.grid().at(0, 1, 4);
        scene.world().setBlock(poi1, class_2246.field_10205.method_9564(), true);
        scene.special().movePointOfInterest(poi1);
        scene.idle(20);
        scene.world().setBlock(poi2, class_2246.field_10205.method_9564(), true);
        scene.special().movePointOfInterest(poi2);
        scene.overlay().showText(20).text("Point of Interest").pointAt(util.vector().centerOf(poi2));
        scene.idle(20);
        scene.world().destroyBlock(poi1);
        scene.special().movePointOfInterest(poi1);
        scene.idle(20);
        scene.world().destroyBlock(poi2);
        scene.special().movePointOfInterest(poi2);
    }

    public static void sectionsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_sections", "Sections");
        scene.showBasePlate();
        scene.idle(10);
        scene.rotateCameraY(95.0f);
        class_2338 mergePos = util.grid().at(1, 1, 1);
        class_2338 independentPos = util.grid().at(3, 1, 1);
        Selection toMerge = util.select().position(mergePos);
        Selection independent = util.select().position(independentPos);
        Selection start = util.select().layersFrom(1).substract(toMerge).substract(independent);
        scene.world().showSection(start, class_2350.field_11033);
        scene.idle(20);
        scene.world().showSection(toMerge, class_2350.field_11033);
        ElementLink<WorldSectionElement> link = scene.world().showIndependentSection(independent, class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).text("This Section got merged to base.").pointAt(util.vector().topOf(mergePos));
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.RED).text("This Section renders independently.").pointAt(util.vector().topOf(independentPos));
        scene.idle(40);
        scene.world().hideIndependentSection(link, class_2350.field_11033);
        scene.world().hideSection(util.select().fromTo(mergePos, util.grid().at(1, 1, 4)), class_2350.field_11033);
        scene.idle(20);
        Selection hiddenReplaceArea = util.select().fromTo(2, 1, 2, 4, 1, 4).substract(util.select().position(4, 1, 3)).substract(util.select().position(2, 1, 3));
        scene.world().hideSection(hiddenReplaceArea, class_2350.field_11036);
        scene.idle(20);
        scene.world().setBlocks(hiddenReplaceArea, class_2246.field_10458.method_9564(), false);
        scene.world().showSection(hiddenReplaceArea, class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showOutlineWithText(hiddenReplaceArea, 30).colored(PonderPalette.BLUE).text("Seamless substitution of blocks");
        scene.idle(40);
        ElementLink<WorldSectionElement> helicopter = scene.world().makeSectionIndependent(hiddenReplaceArea);
        scene.world().rotateSection(helicopter, 50.0, 1800.0, 0.0, 60);
        scene.world().moveSection(helicopter, util.vector().of(0.0, 4.0, 5.0), 50);
        scene.overlay().showText(30).colored(PonderPalette.BLUE).text("Up, up and away.").independent(30);
        scene.idle(40);
        scene.world().hideIndependentSection(helicopter, class_2350.field_11036);
    }
}

